<?php
/**
* Partial that generates the markup for a checkbox with its corresponding label. 
*
* Form markup generator partials are designed to follow object-oriented-esque patterns of inheritance.  This partial will by default be used by the 
* {@link Checkbox_markup_generator} and all of its children that do not have a partial named after their {@link Field_markup_generator::$_type type}.
* If you wish to override this partial in your application, please follow the instructions in the "Partials and Markup Generation" section of the
* {@link Field_markup_generator} class documentation.
*
* The checkbox partial is a little different than most of the field container partials, as we want the checkbox to be inside of the label to increase clickable space.
* For this reason, we will not be using the markup generated from the {@link _label.php} partial, and will be generating a label here instead.  
*
* For checkboxes, we assume that the label text should be to the right of the checkbox.  (To build otherwise, you may call 
* {@link Field_markup_generator::field_markup() field_markup} and {@link Field_markup_generator::label_markup() label_markup()} on their own instead of calling the 
* {@link Field_markup_generator::markup() markup()} method, or override this partial.  Additionally, we'll append comments as normal-sized text after the label, since 
* putting them under the input doesn't work too well with checkboxes.
*
* Like all {@link Field_markup_generator} partials, this partial expects to be passed a copy of the markup generator calling it, called $markup_generator.
* @package icarus
* @subpackage form-markup-generator
*
* @author M. Gibbs <gibbs_margaret@bah.com> Last updated 2012-08-02
*/

if(!isset($markup_generator) || !is_a($markup_generator, 'Field_markup_generator'))
	$this->error->should_be_a_field_markup_generator($markup_generator);

$markup_generator->referral_label = $markup_generator->referral_label; //NOT redundant - making sure it's set instead of being auto-generated.	
$markup_generator->label_text = $field_markup.' '.$markup_generator->label_text; //we want the field markup to be inside of the label for checkboxes

?>
<div class="form-group <?php echo implode(' ', $markup_generator->classes('-form-group')) ?>" id="<?php echo $markup_generator->id_for_container ?>">
	<span class="field-container <?php echo implode(' ', $markup_generator->classes('-field-container')) ?>">
		<?php echo $markup_generator->label_markup() ?>
    <?php if(!$markup_generator->property_is_empty('comment')): ?><div class="form-field-comment"><?php echo $markup_generator->comment ?></div><?php endif ?>
  </span>
</div>